# Общие сведения

Текущий проект - это шаблон для начала разработки backend кастомизации продукта **Universe MDM**. Шаблон поможет вам быстро начать разработку с использованием нашего **SDK**. Он содержит предварительно настроенные зависимости, но не включает примеры кода и лучшие практики.

Описание backend SDK содержится в официальной документации.

# Авторизация на публичном nexus

Перед установкой необходимо авторизоваться во внешнем Nexus-репозитории Universe Data.
Для этого нужно отредактировать файл `project.properties`, внеся в него ваши данные авторизации в Nexus.
Вместо `your-username` подставьте ваш логин, а вместо `your-password` подставьте ваш пароль.

```properties
NEXUS_DOMAIN_NAME=repository.universe-data.ru

# Логин для авторизации в Nexus
NEXUS_REPOSITORY_USER=<your-username>
# Пароль для авторизации в Nexus
NEXUS_REPOSITORY_PASSWORD=<your-password>
```

# Установка зависимостей

Зависимости можно установить как отдельно, так и при сборке проекта.\
Для установки зависимостей без сборки, воспользуйтесь командой:
```shell
# Unix / macOS
./gradlew dependencies --refresh-dependencies

# Windows (cmd или PowerShell)
gradlew.bat dependencies --refresh-dependencies
```

# Сборка проекта

Если вы выбрали установку зависимостей отдельно от сборки, то для сборки выполните:
```shell
# Unix / macOS
./gradlew clean build
# Windows
gradlew.bat clean build
```

Если же вы хотите установить зависимости вместе со сборкой, используйте:
```shell
# Unix / macOS
./gradlew build --offline
# Windows
gradlew.bat build --offline
```
