import { AcceptOAuth2ConsentRequestSession, OAuth2ConsentRequest } from "@ory/hydra-client-fetch";

// <givenName>_<middleName>_<familyName>@universe-data.ru
const emailRegex = /(.+)_(.+)_(.+)@universe-data.ru$/;
const correctPassword = 'password';

export const checkUserInfo = (email: string, password: string) => {
    return emailRegex.test(email) && password === correctPassword;
}

export const getFakeInfoFromEmail = (email: string) => {
    const match = email.match(emailRegex);
    if (!match) {
        throw new Error("Invalid email provided");
    }

    const [_, givenName, middleName, familyName] = match;

    return {
        email,
        givenName,
        middleName,
        familyName
    };
}

export const universeFakeSession = (
  grantScope: string[],
  request: OAuth2ConsentRequest,
  session: AcceptOAuth2ConsentRequestSession,
): AcceptOAuth2ConsentRequestSession => {
  const {
        email,
        givenName,
        middleName,
        familyName
    } = getFakeInfoFromEmail(request.subject ?? '');

  let idToken: { [key: string]: any } = {}

  if (grantScope.indexOf("openid") > -1) {
    idToken = {
        email,
        name: `${givenName}_${middleName}_${familyName}`,
        given_name: givenName,
        middle_name: middleName,
        family_name: familyName,
    };
  }

  return {
    access_token: session.access_token,
    id_token: {
      ...idToken,
      ...session.id_token,
    },
  }
}
