package org.example;

import com.universe.mdm.rest.v1.oauth2.type.HttpResponse;
import com.universe.mdm.rest.v1.oauth2.type.OAuth2UserInfo;
import org.junit.jupiter.api.Test;

import java.util.Collections;

import static org.junit.jupiter.api.Assertions.*;

class HydraOAuth2ProviderTest {

    private static final String JSON = "{\n" +
        "    \"birthdate\": \"string\",\n" +
        "    \"email\": \"admin@hotmail.com\",\n" +
        "    \"email_verified\": true,\n" +
        "    \"family_name\": \"Ivanov\",\n" +
        "    \"gender\": \"string\",\n" +
        "    \"given_name\": \"Ivan\",\n" +
        "    \"locale\": \"ru\",\n" +
        "    \"middle_name\": \"Ivanovich\",\n" +
        "    \"name\": \"Ivanov Ivan Ivanovich\",\n" +
        "    \"nickname\": \"string\",\n" +
        "    \"phone_number\": \"string\",\n" +
        "    \"phone_number_verified\": true,\n" +
        "    \"picture\": \"string\",\n" +
        "    \"preferred_username\": \"string\",\n" +
        "    \"profile\": \"string\",\n" +
        "    \"sub\": \"string\",\n" +
        "    \"updated_at\": 0,\n" +
        "    \"website\": \"string\",\n" +
        "    \"zoneinfo\": \"string\"\n" +
        "}";

    @Test
    void extractUserInfo() {
        HydraOAuth2Provider provider = new HydraOAuth2Provider();

        OAuth2UserInfo i = provider.extractUserInfo(
            new HttpResponse(200, Collections.emptyMap(), JSON.getBytes())
        );

        assertEquals(i.getLogin(), "hydra_abcdef_Ivanov_Ivan_Ivanovich");
        assertEquals(i.getEmail(), "admin@hotmail.com");
        assertEquals(i.getLocale().getLanguage(), "ru");
    }
}
