# Общие сведения
Этот проект демонстрирует пример добавления в Universe MDM поддержки протокола авторизации [OAuth 2.0](https://oauth.net/2/).

## Описание компонентов
Проект состоит из следующих частей:
 - `hydra` --- сервер OAuth2. Ответственен за:
	 - Регистрация клиентских приложений, валидация их redirect URI, scopes
	 - Генерация запросов на аутентификацию, перенаправление на `consent-provider`
	 - Обработка запросов авторизации и токенов доступа
	 - Выдача access tokens, refresh tokens, ID tokens
 - `consent-provider` --- форма логина, предоставляемая серверу авторизации:
	 - Аутентификация пользователей (отрисовка формы входа, проверка учетных данных)
	 - Отображение запрашиваемые клиентом scopes (например, "Доступ к email")
	 - Возвращение серверу авторизации результата логина/согласия
 - `backend-library` --- адаптер для бэкенда MDM под конкретный сервер авторизации

## Взаимодействие между компонентами
Существует несколько сценариев OAuth2 авторизации. В Universe MDM присутсвует поддержка самого популярного из них -- Authorization Code Flow, суть которого состоит в следующем:

1.  **Начало процесса**:
	1. Неавторизированный пользователь переходит на любую страницу в MDM, в адресе которой присутствуют следующие query-параметры: `sso=true`, `ssoType=oauth2`, `oauth2Provider=PROVIDER_ID`, где `PROVIDER_ID` совпадает со значением соответствующей переменной окружения в `.env`.
	2. На бэкенд посылается запрос с query-параметром `oauth2`, равным имени сервиса авторизации. По этому значению бэкенд понимает, какой адаптер ему использовать
	3. Бэкенд, найдя нужный адаптер (`backend-library`), редиректит пользователя на сервер авторизации (`hydra`)
	4. Сервер авторизации регистрирует попытку логина и перенаправляет пользователя на `consent-provider`, передавая id попытки логина в query-параметре `login_challenge`
2.  **Аутентификация**:
    1. `consent-provider` показывает форму входа
    2. После успешной аутентификации `consent-provider` перенаправляет пользователя на экран согласия
3.  **Согласие (Consent)**:
    1. `consent-provider` показывает запрашиваемые приложением разрешения (scopes)
    2. После решения пользователя `consent-provider` отправляет `hydra` результат согласия
4.  **Callback-страница**:
    1. Hydra генерирует authorization code и перенаправляет пользователя на специальную `callback`-страницу на фронтенде MDM, передавая authorization code в качестве query-параметра
    2. На бэкенд посылается запрос, содержащий authorization code
5. **Создание внешнего пользователя**
	1. Бэкенд с помощью адаптера посылает запрос, содержащий authorization code, на сервер авторизации
	2. В ответ на этот запрос он получает токен доступа к информации, разрешение на которую дал пользователь
	3. Бэкенд с помощью этого токена получает информацию о пользователе
	4.  Полученный пользователь сохраняется в БД как внешний или обновляется, если уже существовал
	5. Генерируется внутренний токен для авторизации и посылается в ответе на запрос из пункта *4.2*
6. **Завершение процесса**
	1. Фронтенд, получая внутренний токен, завершает авторизацию
	2. Пользователь перенаправляется на главную страницу приложения

## Установка
Перед установкой необходимо авторизоваться во внутреннем репозитории `docker`:
```bash
docker login docker.universe-data.ru/unidata-ee
```

Подготовка закончена, теперь можно запускать сборку сервисов:
```bash
docker compose build
```

## Запуск
Перед запуском необходимо убедиться, что значение переменной `MDM_DEPLOY_NETWORK_NAME` совпадает с именем docker-сети, в которой находится контейнер MDM-бэкенда. Имя сети будет напротив имени контейнера в результате следующей команды:
```bash
docker ps --format '{{ .Names }} {{ json .Networks }}'
```
Теперь можно запускать сервисы:
```bash
docker compose up -d
```
После запуска в `volumes/backend-library` появится `.jar`-файл с библиотекой, которую требуется загрузить в разделе "Библиотеки".

Также необходимо в разделе "Параметры системы" указать значение параметра `com.universe.mdm.rest.v1.oauth2.redirect.address`, значению переменной `HYDRA_CLIENT_REDIRECT_URI`.

## Конфигурация
Вся необходимая конфигкрация задаётся в переменных `.env`-файла:
 - `PROVIDER_ID` --- идентификатор адаптера к серверу авторизации
 - `HYDRA_CLIENT_ID` --- id клиента, который будет зарегистрирован в hydra и которым будет пользоваться `backend-library`
 - `HYDRA_CLIENT_NAME` --- имя клиента, которое будет отображаться на экране согласия
 - `HYDRA_CLIENT_SECRET` --- пароль клиента
 - `HYDRA_CLIENT_REDIRECT_URI` --- адрес callback-страницы, на которую будет перенаправляться пользователь после разрешения на доступ к своим данным
 - `HYDRA_PUBLIC_OUTER_PORT` --- порт, по которому будет доступно публичное API сервера авторизации
 - `HYDRA_SYSTEM_SECRET` --- код, необходимый для создания клиента на сервере авторизации 
 - `CONSENT_PROVIDER_PORT` --- порт, по которому будет доступен consent provider
 - `MDM_DEPLOY_NETWORK_NAME` --- имя сети, в которой находится контейнер MDM-бэкенда
